﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Managed_Hook;
using System.Diagnostics;
using System.Collections;
using System.Threading;
using System.IO;

namespace Makro
{
    public partial class Form1 : Form
    {
        //*******************Variablen*******************************
        #region Variablen

        private const string speicherodner = @"\MAKROSAVE";
        private Stopwatch watch = new Stopwatch();
        private KeyboardHook keyboardHook = null;

        /// <summary>
        /// enthält die aktuell gedrückten Tasten
        /// </summary>
        private string s_gedrueckt;
        /// <summary>
        /// true: ein Makro wird gerade ausgeführt
        /// false: kein Makro wird gerade ausgeführt
        /// </summary>
        private bool b_makrolaeuft;
        /// <summary>
        /// true: Das laufende Makro wird abgebrochen
        /// false: Das laufende Makro läuft weiter
        /// </summary>
        private bool b_makroabbruch;
        /// <summary>
        /// true: Start Stop Tastenkombination wird gesetzt
        /// </summary>
        private bool b_set_an_aus;
        /// <summary>
        /// true: es wird Aufgenommen
        /// </summary>
        private bool b_aufnahme;
        /// <summary>
        /// true: Makros werden ausgelöst
        /// false: Makros werden nicht ausgelöst
        /// </summary>
        private bool b_makroan;
        /// <summary>
        /// false: Nächste Tastenkombination während Aufnahme ist Makroauslöser
        /// </summary>
        private bool b_startkeyset;
        #endregion Variablen

        //*******************Methoden*******************************
        #region Methoden

        //*******************************GET SET START*************************************
        //Get Set Teil um Formelemente vom Hauptprogram aus zu setzen und auszulesen
        #region GET SET
        //***************checkboxen************************

        /// <summary>
        /// true: Markos werden nacheinander ausgeführt
        /// false: Laufende Makros werden unterbrochen und direkt das neue gestartet
        /// </summary>
        public bool cbmakronacheinander
        {
            get
            {
                return this.cb_makronacheinander.Checked;
            }

            set
            {
                this.cb_makronacheinander.Checked = value;
            }
        }
        /// <summary>
        /// true: Beim Aufnehmen vom Makros wird zwischen den Tasteneingaben eine Feste Zeit (aus tb_ms) gespeichert
        /// false: Beim Aufnehmen werden die tatsächlichen Zeiten Zwischen den Tastatureingaben verwendet
        /// </summary>
        public bool cbms
        {
            get
            {
                return this.cb_ms.Checked;
            }

            set
            {
                this.cb_ms.Checked = value;
            }
        }
        //***************textboxen***********************
        /// <summary>
        /// Dateiname in welche die Makros gespeichert sind
        /// </summary>
        public string tbdatei
        {
            get
            {
                return this.tb_datei.Text;
            }

            set
            {
                this.tb_datei.Text = value;
            }
        }
        /// <summary>
        /// Taste(nkombination) welche die Makrofunktion Startet und beendet
        /// </summary>
        public string tbanaus
        {
            get
            {
                return this.tb_an_aus.Text;
            }

            set
            {
                this.tb_an_aus.Text = value;
            }
        }
        /// <summary>
        /// Text welche die ms festlegt welche bei festen Zeiten (bei der Aufnahme) gespeichert werden sollen
        /// </summary>
        public string tbms
        {
            get
            {
                return this.tb_ms.Text;
            }

            set
            {
                this.tb_ms.Text = value;
            }
        }
        #endregion
        //*******************************GET SET ENDE*************************************

        /// <summary>
        /// Constuktor
        /// </summary>
        public Form1()
        {
            InitializeComponent();
            keyboardHook = new KeyboardHook();
            keyboardHook.KeyboardEvent += new KeyboardHook.KeyboardEventHandler(keyboardHook_KeyboardEvent);
            keyboardHook.Install(); //Hook Installieren

            //Startwerte für Variablen setzen
            s_gedrueckt = string.Empty;

            b_makroabbruch = false;
            b_makrolaeuft = false;
            b_set_an_aus = false;
            b_aufnahme = false;
            b_startkeyset = false;
        }
        /// <summary>
        /// Schaltet alle Buttons bis auf den übergeben aus
        /// </summary>
        /// <param name="btn"></param>
        void disable(Button btn)
        {
            foreach (object b in this.Controls)
            {
                if (b is Button)
                    ((Button)b).Enabled = false;
            }
            btn.Enabled = true;
        }
        /// <summary>
        /// Schaltet alle Buttons ein
        /// </summary>
        void enable()
        {
            foreach (object b in this.Controls)
            {
                if (b is Button)
                    ((Button)b).Enabled = true;
            }

        }

        /// <summary>
        /// führt LoadValues aus und schreibt den übergebenen String in die Textbox tbdatei
        /// </summary>
        /// <param name="sfile"></param>
        private void oeffnen(string sfile)
        {
            tbdatei = sfile.ToString();
            Program.DATEI = dateien.LoadValues(sfile.ToString());
            anzeige1.makrolisteladen();
        }

        /// <summary>
        /// erstellt einen Punkt neben dem Aufnahmebutton mit dem übergebenen Brush
        /// </summary>
        /// <param name="pinsel"></param>
        private void Aufnahmepunkt(Brush pinsel)
        {
            Bitmap bmp = new Bitmap(pb_aufnahme.Width, pb_aufnahme.Height);
            Graphics g = Graphics.FromImage(bmp);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            g.FillEllipse(pinsel, 0, 0, bmp.Width - 1, bmp.Height - 1);
            pb_aufnahme.Image = bmp;
        }

        /// <summary>
        /// Führt die Tasteneingaben des Makros durch
        /// </summary>
        void Tastenausgabe(object o)
        {
            string[] sarray = (string[])o;
            if (!cb_makronacheinander.Checked)
            {
                while (b_makrolaeuft)
                {
                    b_makroabbruch = true;
                    Thread.Sleep(100);
                }
            }
            lock (this)
            {
                b_makroabbruch = false;
                b_makrolaeuft = true;
                for (int i = 1; i < sarray.GetLength(0); ++i)
                {
                    watch.Reset();
                    watch.Start();
                    for (int a = 0; a < (int.Parse(sarray[i]) / 100); a++)
                    {
                        if (b_makroabbruch)
                            break;
                        Thread.Sleep(90);
                    }
                    if (b_makroabbruch)
                        break;
                    watch.Stop();
                    if ((int.Parse(sarray[i])) > (int)watch.ElapsedMilliseconds)
                        Thread.Sleep((int.Parse(sarray[i])) - (int)watch.ElapsedMilliseconds);
                    ++i;
                    Senden.TextSenden(sarray[i]);
                 }
                b_makrolaeuft = false;
            }

        }

        /// <summary>
        /// Wird ausgelöst wenn eine Taste gedrückt wird
        /// </summary>
        /// <param name="kEvent"></param>
        /// <param name="key"></param>
        private void keyboardHook_KeyboardEvent(KeyboardEvents kEvent, Keys key)
        {
            if (kEvent == KeyboardEvents.KeyDown || kEvent == KeyboardEvents.SystemKeyDown)
            {
                if (!s_gedrueckt.Contains(key.ToString()))
                    // if(s_gedrueckt.Length == 0)
                    s_gedrueckt += key.ToString();
                // else
                // " " + s_gedrueckt += key.ToString();
            }
            else if (kEvent == KeyboardEvents.KeyUp || kEvent == KeyboardEvents.SystemKeyUp)
            {
                if (b_set_an_aus)//neue Start Stop Tasten werden Gesetzt
                #region Start Stop Tasten setzen
                {
                    tb_an_aus.Text = s_gedrueckt;
                    enable();
                    b_set_an_aus = false;
                }
                #endregion
                else if (b_aufnahme)//Aufnahme neuer Makros
                #region Aufnahme
                {
                    if (!b_startkeyset)//Wenn noch kein Auslöser gesetzt ist
                    {
                        if (s_gedrueckt != tb_an_aus.Text && s_gedrueckt != "")
                        {
                            anzeige1.addmakroausloeser(s_gedrueckt);
                            anzeige1.co_makroausloeser.SelectedIndex = anzeige1.co_makroausloeser.Items.Count - 1;
                            watch.Reset();
                            watch.Start();
                            b_startkeyset = true; //Makroauslöser 
                        }
                    }
                    else //Makroaufnahme
                    {
                        if (s_gedrueckt != tb_an_aus.Text && s_gedrueckt != "")
                        {
                            if (cb_ms.Checked) //Feste Zeiten zwischen den Tastenkombinationen
                                anzeige1.addsubmakro(tb_ms.Text, s_gedrueckt);

                            else //Zeiten zwischen den Tastenkombinationen während der Aufnahme werden verwendent
                            {
                                if (watch.IsRunning)
                                {
                                    watch.Stop();
                                    anzeige1.addsubmakro(watch.ElapsedMilliseconds.ToString(), s_gedrueckt);
                                    watch.Reset();
                                    watch.Start();
                                }
                            }
                            anzeige1.co_submakro.SelectedIndex = anzeige1.co_submakro.Items.Count - 1;
                        }
                    }
                }
                #endregion

                else if (b_makroan)//Wenn Makrofunktion eingeschaltet ist
                #region Tasten überprüfen und gegf. Makros ausführen
                {
                    if (s_gedrueckt != "")
                    {
                        if (s_gedrueckt == tb_an_aus.Text)//überprüfe ob Makrobelegung ausgeschaltet werden soll
                        {
                            b_makroan = false;
                        }
                        else //überprüfe ob gedrückte Tasten mit Makro belegt sind
                        {
                            foreach (string[] sarray in Program.DATEI.Liste)
                            {
                                if (sarray[0] == s_gedrueckt)
                                {
                                    ThreadPool.QueueUserWorkItem(new WaitCallback(Tastenausgabe), sarray);
                                }
                            }
                        }
                    }
                }
                #endregion

                else // Überprüfe ob Makrofunktion eingeschaltet werden soll
                {
                    if (s_gedrueckt == tb_an_aus.Text)
                        b_makroan = true;
                }
                s_gedrueckt = string.Empty;
            }

        }

        /// <summary>
        /// Instanze Killen und Hook Deinstallieren
        /// </summary>
        /// <param name="disposing"></param>
        private void dispose(bool disposing)
        {
            if (keyboardHook != null)
            {
                keyboardHook.dispose();
            }
            base.Dispose(disposing);
        }
        #endregion
        
        #region Events

        private void Form1_Load(object sender, EventArgs e)
        {
            if (File.Exists(tb_datei.Text))
            {
                oeffnen(tb_datei.Text);
            }
            Aufnahmepunkt(Brushes.Red);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            WerteSpeichern();
            b_makroabbruch = true;
            dispose(true);
        }
        private void WerteSpeichern()
        {
            // Einstellungen aus dem Form in die Einstellungsklasse zum Speichern übertrage
            Program.Einstellung.smakrodatei = tbdatei;
            Program.Einstellung.sms = tbms;
            Program.Einstellung.sstart_stop = tbanaus;
            Program.Einstellung.bnacheinander = cbmakronacheinander;
            Program.Einstellung.bms = cbms;
        }

        #region Buttons

        private void btn_aufnahme_Click(object sender, EventArgs e)
        {
            if (!b_aufnahme)
            {
                disable(btn_aufnahme); 
                b_aufnahme = true; //es wird nun aufgenommen
                b_startkeyset = false;

                //textboxen Ausschalten
                tb_ms.Enabled = false;
                tb_datei.Enabled = false;
                //anzeige1 Ausschalten
                anzeige1.Enabled = false;
                label_1.Focus();

                Aufnahmepunkt(Brushes.Green);

            }
            else
            {
                if (watch.IsRunning)
                    watch.Stop();

                //makrosfuellen();
                enable();
                //textboxen Einschalten
                tb_ms.Enabled = true;
                tb_datei.Enabled = true;
                //anzeige1 Einschalten
                anzeige1.Enabled = true;

                b_aufnahme = false; //es wird nicht mehr aufgenommen
                Aufnahmepunkt(Brushes.Red);
            }
        }

        private void btn_an_aus_Click(object sender, EventArgs e)
        {
            if (!b_set_an_aus)
            {
                b_set_an_aus = true;
                disable(btn_an_aus);
                s_gedrueckt = string.Empty;
            }
            else
            {
                b_set_an_aus = false;
                enable();
            }

        }

        #endregion

        private void btn_oeffnen_Click(object sender, EventArgs e)
        {
            if (!Directory.Exists(Application.StartupPath + speicherodner))
                Directory.CreateDirectory(Application.StartupPath + speicherodner);

            openFileDialog1.InitialDirectory = Application.StartupPath + speicherodner;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                oeffnen(openFileDialog1.FileName);
            }
        }

        private void btn_speichern_Click(object sender, EventArgs e)
        {
            if (!Directory.Exists(Application.StartupPath + speicherodner))
                Directory.CreateDirectory(Application.StartupPath + speicherodner);

            saveFileDialog1.InitialDirectory = Application.StartupPath + speicherodner;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                Program.DATEI.SaveValues(saveFileDialog1.FileName);
                tbdatei = saveFileDialog1.FileName;
                MessageBox.Show("Datei erfolgreich gespeichert.", "Gespeichert", MessageBoxButtons.OK, MessageBoxIcon.Information);
            }

        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (b_makroan)
                b_makroan = false;
            else
                b_makroan = true;
        }
        #endregion

    }
}
