﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace projekt
{
    delegate void VoidDelegate();
    delegate void AddClientDelegate(IClientService client);
    delegate ShootEnum PointDelegate(Point p);
    delegate void AktDelegate ();

    /// <summary>
    /// Hier werden die Delegaten für die Funktionen deklariert, auf die der Server zugreifen kann:
    /// "shoot", "connect" und "aktivieren"
    /// </summary>
    public class ServerService : MarshalByRefObject, IServerService
    {
        public static Form1 theForm;

        private static ServerService _service;

        public ServerService()
        {
            _service = this;
        }

        /// <summary>
        /// Ruft über einen Delegaten "point Delegate" die Funktion "treffen" auf, und übergibt dieser den Punkt p.
        /// </summary>
        /// <param name="p"></param>
        /// <returns></returns>
        public ShootEnum shoot(Point p)
        {
            return (ShootEnum)theForm.Invoke(new PointDelegate(theForm.treffen), new object[] { p });
        }

        /// <summary>
        /// Ruft über Delegaten die Funktionen "AddClient" und "enemyconnect" auf, stellt also die Verbindung zum Client her.
        /// </summary>
        /// <param name="client"></param>
        public void connect(IClientService client)
        {
            theForm.Invoke(new AddClientDelegate(theForm.AddClient), new object[] { client });
            theForm.Invoke(new VoidDelegate(theForm.enemyconnect));
        }
        
        /// <summary>
        /// Ruft über einen Delegaten die Funktion "changeplayer" auf, führt also einen Spielerwechsel durch
        /// </summary>
        public void aktivieren()
        {
            theForm.Invoke(new AktDelegate(theForm.changeplayer));
        }
    }

    public class ClientService : MarshalByRefObject, IClientService
    {
        public static Form1 theForm;

        public ClientService(Form1 tf)
        {
            theForm = tf;
        }

        /// <summary>
        /// Ruft über einen Delegaten "point Delegate" die Funktion "treffen" auf, und übergibt dieser den Punkt p.
        /// </summary>
        /// <param name="p"></param>
        /// <returns></returns>
        public ShootEnum shoot(Point p)
        {
            return (ShootEnum)theForm.Invoke(new PointDelegate(theForm.treffen), new object[] { p });
        }

        /// <summary>
        /// /// Ruft über einen Delegaten die Funktion "changeplayer" auf, führt also einen Spielerwechsel durch
        /// </summary>
        public void aktivieren()
        {
            theForm.Invoke(new AktDelegate(theForm.changeplayer));
        }
    }
}
