﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting;
using System.Net;
using System.Collections;
using System.Runtime.Serialization.Formatters;

namespace projekt
{
    public partial class Form1 : Form
    {
        List<Schiffe> LS;
        Bitmap bmp;
        Spielfeld spielfeld1;
        TcpChannel channel;
        const int PORT = 9898;
        const string SERVER = "Server";
        const string APPNAME = "SinkShip";
        bool everythingOK;
        IServerService server;
        IClientService client;
        bool isServer;
        Graphics g;
        List<Point> WL, TL;
  
        // Hier wird die Eigenschaft everythingOK zurückgegeben, die im Hauptprogramm abgefragt wird, bevor Form1 startet.
        public bool EverythingOK            
        {
            get
            {
                return everythingOK;
            }
        }

        public Form1()
        {
            everythingOK = false;           //Wird wieder zurückgesetzt 
            ServerService.theForm = this;   
            InitializeComponent();

            spielfeld1 = new Spielfeld();
            LS = new List<Schiffe>();       //Liste der eigenen Schiffe
            TL = new List<Point>();         //Liste der gelandeten Treffer auf dem gegnerischen Spielfeld (werden in der Grafik mit einem Kreuz markiert)
            WL = new List<Point>();         //Liste der Fehlschüsse auf dem gegnerischen Spielfeld (werden in der Grafik mit einem Kreis markiert)

            //Point testpoint = new Point(3, 3);
            //spielfeld1[testpoint] = 1;

            bmp = new Bitmap(pictureBox1.Width, pictureBox1.Height);                //Bitmap auf der Picture Box, in der die Grafik g gezeichnet wird
            g = Graphics.FromImage(bmp);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;     //weiche Kanten
            Pen p1 = new Pen(Color.Black, 1f);                                      //Pen für die Spielfeldlinien

            for (int i = 0; i < 17; i++)                                            //Zeichnen des Spielfelds
            {
                g.DrawLine(p1, i * 30, 0, i * 30, 450);
                g.DrawLine(p1, 0, i * 30, 450, i * 30);
            }
            pictureBox1.Image = bmp;

            radioButton1.Checked = true;                    //Radiobutton 1 steht für "Schiffe setzen", und kann nicht zusammen mit RB2 gecheckt werden
            radioButton2.Enabled = false;                   //RB 2 bedeutet "Spielen" und soll erst aktiviert werden, nachdem alle Schiffe gesetzt worden sind
            radioButton4.Checked = true;                    //Die restlichen RBs sind unabhängig von Rb 1 und 2 und stehen für die verschiedenen Schiffe
            
            HostGame hg = new HostGame();
            if (hg.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    if (hg.HostsGame)           //Spieler = Server?
                    {
                        isServer = true;        // Marker, um während des Spiels zwischen Server und Client unterscheiden zu können
                        //Initialisierung des Netzwerks:
                        RemotingConfiguration.CustomErrorsMode = CustomErrorsModes.Off;
                        RemotingConfiguration.ApplicationName = APPNAME;
                        BinaryClientFormatterSinkProvider bcfs = new BinaryClientFormatterSinkProvider();
                        BinaryServerFormatterSinkProvider bsfs = new BinaryServerFormatterSinkProvider();
                        bsfs.TypeFilterLevel = TypeFilterLevel.Full;
                        IDictionary id = new Hashtable();
                        id = new Hashtable();
                        id.Add("port", PORT);
                        id.Add("typeFilterLevel", TypeFilterLevel.Full);
                        id.Add("name", System.Guid.NewGuid().ToString());
                        channel = new TcpChannel(id, bcfs, bsfs);
                        ChannelServices.RegisterChannel(channel, false);
                        RemotingConfiguration.RegisterWellKnownServiceType(typeof(ServerService), SERVER, WellKnownObjectMode.SingleCall);
                        this.Enabled = false;
                        this.Text = "Warte auf Gegner...";
                    }
                    else
                   {                                        //Spieler = Client
                        isServer = false;
                        channel = new TcpChannel(0);
                        ChannelServices.RegisterChannel(channel, false);
                        client = new ClientService(this);
                        server = (IServerService)Activator.GetObject(typeof(IServerService), "tcp://" + hg.IP + ":" + PORT + "/" + APPNAME + "/" + SERVER);
                        server.connect(client);
                        enemyconnect();
                    }
                    everythingOK = true;                    //Spielstart
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, "Ein Fehler ist aufgetreten", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }
            }
        }


        /// <summary>
        /// Mausklick auf das Spielfeld ruft je nach Aktivierung der Radiobuttons eine Funktion zum Setzen von Schiffen oder zum Beschießen des
        /// gegnerischen Spielfeldes auf.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            Graphics g = Graphics.FromImage(bmp);
            g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
            Pen pen1 = new Pen(Color.Black, 1f);

            for (int i = 0; i < 17; i++)
            {
                g.DrawLine(pen1, i * 30, 0, i * 30, 450);
                g.DrawLine(pen1, 0, i * 30, 450, i * 30);
            }
            double d1 = e.X / 30, d2 = e.Y / 30;     //Zuweisung der Koordinaten des Mausklicks zu dem entsprechenden Feld des Spielfelds
            int x = (int)d1, y = (int)d2;
            Point p = new Point(x, y);                      
            
            if (radioButton1.Checked)               //RB1 = checked bedeutet Schiffe setzen, Spiel noch nicht erlaubt              
            {
                bool horizontal;
                int groesse;
                if (radioButton11.Checked)           //Im Folgenden werden den Radiobuttons die
                {                                    //entsprechenden Eigenschaften der Schiffe zugeordnet
                    groesse = 5;
                    horizontal = false;
                }
                else if (radioButton10.Checked)
                {
                    groesse = 4;
                    horizontal = true;
                }
                else if (radioButton9.Checked)
                {
                    groesse = 3;
                    horizontal = false;
                }
                else if (radioButton8.Checked)
                {
                    groesse = 3;
                    horizontal = true;
                }
                else if (radioButton7.Checked)
                {
                    groesse = 2;
                    horizontal = false;
                }
                else if (radioButton6.Checked)
                {
                    groesse = 2;
                    horizontal = true;
                }
                else if (radioButton5.Checked)
                {
                    groesse = 1;
                    horizontal = true;
                }
                else
                {
                    groesse = 1;
                    horizontal = true;
                }

                switch (horizontal)
                {
                            //Überprüfen, ob das Schiff auch komplett im Spielfeld liegt:
                    case true:
                        if (x + groesse < 16)
                        {
                            Schiffe ship = new Schiffe(p, groesse, horizontal, LS);
                            if (ship.Cross(LS) == false)                    //Überschneidung mit schon vorhandenem Schiff?
                            {
                                LS.Add(ship);
                                ship.draw(spielfeld1, g);                   //Schiff zeichnen
                                CheckNewRB();                               //nächstes Schiff oder schon alle gesetzt?
                            }
                        }
                        else                                                
                            MessageBox.Show("Das Schiff liegt nicht vollständig innerhalb des Spielfelds!");
                        break;

                    case false:                                             //Das Gleiche für vertikale Schiffe
                        if (y + groesse < 16)
                        {
                            Schiffe ship = new Schiffe(p, groesse, horizontal, LS);
                            if (ship.Cross(LS) == false)
                            {
                                LS.Add(ship);
                                ship.draw(spielfeld1, g);
                                CheckNewRB();
                            }
                        }
                        else
                            MessageBox.Show("Das Schiff liegt nicht vollständig innerhalb des Spielfelds!");    //Neuer Versuch!
                        break;
                }

            }
            else if (radioButton2.Checked)                      //RB 2 bedeutet alle Schiffe sind gesetzt, Spiel kann beginnen
            {
                ShootEnum target = ShootEnum.KeinTreffer;       //Initialisierung
                if(isServer)                                    //falls Server, beschieße Feld des Clients
                    target = client.shoot(p);
                else
                    target = server.shoot(p);                   //Ansonsten andersherum

                if (target == ShootEnum.KeinTreffer)            //Kein Treffer
                {
                    label1.Text = ("Kein Treffer!");            
                    WL.Add(p);                                  //=> Eintrag in WL  
                    radioButton2.Checked = false;               //=> Spielmodus vorbei
                    radioButton2.Enabled = false;
                    if (isServer)                               //=> der andere Spieler ist dran
                        client.aktivieren();
                    else
                        server.aktivieren();

                }
                else if (target == ShootEnum.Treffer)           //Treffer
                {
                    label1.Text = ("Treffer!!!");
                    TL.Add(p);                                  //=> Eintrag in Trefferliste TL
                }
                else if (target == ShootEnum.Versenkt)          // Versenkt
                {
                    label1.Text = ("Treffer, versenkt!!!");
                    TL.Add(p);                                  //=> Eintrag in Trefferliste
                }
                else if (target == ShootEnum.Sieger)            //Alle Schiffe versenkt
                {
                MessageBox.Show("Sie haben alle feindlichen Schiffe versenkt!!!");
                    TL.Add(p);
                    radioButton2.Checked = false;
                    radioButton2.Enabled = false;               //=> Gewinnner!!
                }

            }

            g.Clear(Color.Empty);                               //Komplettes Spielfeld neu zeichnen:
            foreach (Schiffe Schiff in LS)         
                Schiff.draw(spielfeld1, g);                     //Eigene Schiffe
            foreach (Point punkt in WL)
                g.DrawEllipse(pen1, punkt.X * 30, punkt.Y * 30, 30, 30);    //Kreise für "Daneben"
            foreach (Point punkt in TL)
            {
                g.DrawLine(pen1, punkt.X * 30, punkt.Y * 30, punkt.X * 30 + 30, punkt.Y * 30 + 30);     //Kreuze für Treffer
                g.DrawLine(pen1, punkt.X * 30, punkt.Y * 30 + 30, punkt.X * 30 + 30, punkt.Y * 30);
            }
            pictureBox1.Image = bmp;


        }

        /// <summary>
        /// Ruft für jedes Schiff der Liste LS die Funktion Schiffe.Beschuss auf, und gibt je nach Resultat
        /// einen der Einträge von ShootEnum zurück. Außerdem wird bei einem Treffer das Schiff über Schiffe.draw neu gezeichnet.
        /// </summary>
        /// <param name="p"></param>
        /// <returns></returns>
        public ShootEnum treffen(Point p)
        {

            int index = 20;
            foreach (Schiffe schiff in LS)
            {
                if (index == 20)
                { index = schiff.Beschuss(p, LS); }

            }

            if (index != 20)
            {
                LS[index].draw(spielfeld1, g);
                pictureBox1.Invalidate();
                if (LS[index].Havarie(LS))
                {
                    if (LS.Count == 0)
                    {
                        return ShootEnum.Sieger;
                    }
                    else
                    {
                        return ShootEnum.Versenkt;
                    }
                }
                else
                    return ShootEnum.Treffer;
            }
            return ShootEnum.KeinTreffer;

        }

        /// <summary>
        /// Deaktiviert den eben verwendeten RB, sucht nach dem nächsten noch nicht behandelten RB ( = noch nicht gesetzten Schiff), und checkt diesen.
        /// Außerdem wird über IService.aktivieren der jeweils andere Spieler aktiviert, wenn alle Schiffe gesetzt sind.
        /// </summary>
        private void CheckNewRB()
        {
            List<RadioButton> rbs = new List<RadioButton>();    //Liste der Radiobuttons für die einzelnen Schiffe
            rbs.Add(radioButton4);
            rbs.Add(radioButton5);
            rbs.Add(radioButton6);
            rbs.Add(radioButton7);
            rbs.Add(radioButton8);
            rbs.Add(radioButton9);
            rbs.Add(radioButton10);
            rbs.Add(radioButton11);
            foreach (RadioButton r in rbs)
                if (r.Checked)
                {
                    r.Enabled = false;
                }
            foreach (RadioButton r in rbs)
                if (r.Enabled)
                {
                    r.Checked = true;
                    return;
                }
            radioButton1.Enabled = false;
            radioButton1.Checked = false;
            if (isServer)
                client.aktivieren();
            else
                server.aktivieren();
                
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            ChannelServices.UnregisterChannel(channel);
        }

        /// <summary>
        /// Wirft die MesageBox "Ein Gegner wurde gefunden..." und aktiviert das Spielfenster.
        /// </summary>
        public void enemyconnect()
        {
            MessageBox.Show("Ein Gegner wurde gefunden. Viel Erfolg!");
            Enabled = true;
            Text = "Schiffe versenken";
        }

        public void AddClient(IClientService client)
        {
            this.client = client;
        }

        /// <summary>
        /// Wechselt den Spieler: Falls dieser mit dem Schiffe setzen fertig ist, erscheint im Label "Du bist dran"
        /// und sein Spiel wird aktiviert.
        /// </summary>
        public void changeplayer()
        {
            if (radioButton1.Checked == false)
            {
                radioButton2.Checked = true;
                label1.Text = "Du bist dran!";
                radioButton2.Enabled = true;
            }
        }
    }
}
