﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace projekt
{
    /// <summary>
    /// Funktionen, die nur der Server benutzen kann, hier : connect, Definition in ServerService
    /// </summary>
    public interface IServerService : IService
    {
        void connect(IClientService client);
    }

    /// <summary>
    /// Funktionen, die nur der Client nutzen kann: In diesem fall keine,
    /// es werden nur gemeinsamen Funktionen von IService geerbt
    /// </summary>
    public interface IClientService : IService
    {

    }
    /// <summary>
    /// Hier werden die Funktionen deklariert, die von beiden Benutzern genutzt werden können:
    /// shoot und aktivieren, sie sind in Service definiert.
    /// </summary>
    public interface IService
    {
        ShootEnum shoot(Point p);
        void aktivieren();
    }
    
}
