﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace projekt
{
    public class Schiffe
    {
        public int groesse;             // Länge des Schiffs (1-5)
        List<Point> koords;             // Liste aus Punkten im Spielfeld, auf welchen sich ein Schiff befindet
        List<bool> zustand;             // Liste aus Bool-Werten, welche den Zustand des Schiffes repräsentiert: True = unversehrt, False = getroffen

        /// <summary>
        /// Erstellt ein Schiff mit den unten stehenden Eigenschaften
        /// location: Startpunkt im Spielfeld (links/oben);
        /// groesse: Länge des Schiffs;
        /// horizontal: true = horizontal, fase = vertikal;
        /// LS: Liste der Schiffe, dinet zur Überprüfung von Überschniedungen, Zustand, usw.
        /// </summary>
        /// <param name="location"></param>
        /// <param name="groesse"></param>
        /// <param name="horizontal"></param>
        /// <param name="LS"></param>
        public Schiffe(Point location, int groesse, bool horizontal, List<Schiffe> LS)
        {
            this.groesse = groesse;
            zustand = new List<bool>();
            koords = new List<Point>();
            for (int i = 0; i < groesse; i++)
            {
                if (horizontal)
                {
                    koords.Add(new Point(location.X + i, location.Y));
                }
                else
                {
                    koords.Add(new Point(location.X, location.Y + i));
                }
                zustand.Add(true);
            }
            if (this.Cross(LS))
                MessageBox.Show("Schiffe überkreuzen sich! Es kann pro Kästchen nur ein Schiff platziert werden!");
        }

        /// <summary>
        /// Überprüft aktuelles Schiff auf Überschneidungen mit der Liste "LS" existierender Schiffe (koords)
        /// </summary>
        /// <param name="LS"></param>
        /// <returns></returns>
        public bool Cross(List<Schiffe> LS)
        {
            foreach (Schiffe schiff in LS)
                foreach (Point point in schiff.koords)
                    foreach (Point P in this.koords)
                        if (point == P)
                            return true;            // Überschneidung! => Message Box erscheint
            return false;
        }

        /// <summary>
        /// Überprüft in der Liste LS, ob ein getroffenes Schiff schon vollständig versenkt (zustand[i]= false für alle i im Schiff)
        /// und gibt einen Bool-Wert (true = Havarie) zurück. Bei Havarie wird das Schiff aus der Liste entfernt.
        /// </summary>
        /// <param name="LS"></param>
        /// <returns></returns>
        public bool Havarie(List<Schiffe> LS)
        {

            for (int i = 0; i < groesse; i++)
            {
                if (zustand[i] == true)
                    return false;
            }
            LS.Remove(this);
            return true;
        }

        /// <summary>
        ///Treffer-Überprüfung: Überprüft, ob auf Punkt p ein Schiff der Liste LS liegt. Bei Treffer wird der Index des getroffenen Schiffs in
        ///der Liste LS zurückgegeben. Ansonsten ist der Rückgabewert = 20.
        /// </summary>
        /// <param name="k"></param>
        /// <returns></returns>
        public int Beschuss(Point p, List<Schiffe> LS)
        {
            for (int i = 0; i < groesse; i++)
            {
                if (this.koords[i] == p)
                {
                    zustand[i] = false;
                    return LS.IndexOf(this);
                }
            }
            return 20;


        }

        /// <summary>
        /// Zeichnet das entsprechende Schiff in die Grafik g (=> Picture Box) in rot, falls Feld (koords) schon getroffen, in grau falls unversehrt
        /// ("zustand" = true/false) und schreibt das Schiff ins Spielfeld feld (Inhalt 1).
        /// Außerdem werden die Linien des Spielfelds neu gezeichnet.
        /// </summary>
        /// <param name="feld"></param>
        public void draw(Spielfeld feld, Graphics g)
        {
            Pen pen1 = new Pen(Color.Black, 1f);

            for (int i = 0; i < groesse; i++)
            {
                feld[koords[i]] = 1;
                if (zustand[i] == true)
                {
                    g.FillRectangle(new SolidBrush(Color.DarkGray), koords[i].X * 30, koords[i].Y * 30, 30, 30);
                }
                else
                {
                    g.FillRectangle(new SolidBrush(Color.Red), koords[i].X * 30, koords[i].Y * 30, 30, 30);
                }
            }
            for (int i = 0; i < 17; i++)
            {
                g.DrawLine(pen1, i * 30, 0, i * 30, 450);
                g.DrawLine(pen1, 0, i * 30, 450, i * 30);
            }

        }

    }
}
