﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace projekt
{
    /// <summary>
    ///
    public class Spielfeld
    {
        private int[,] felder;

        public int[,] Felder
        {
            get { return felder; }
            set { felder = value; }
        }
        /// <summary>
        /// Erstellt ein Spielfeld als 15x15 Array, die alle mit Eintrag 0 initialisiert werden
        /// Überladung des Indexoperators: Durch Übergabe eines Points P kann das entsprechende Feld gelesen bzw. gefüllt werden
        /// </summary>
        /// </summary>
        public Spielfeld()
        {
            felder = new int[15, 15];
            for (int i = 0; i < 15; i++)
            {
                for (int j = 0; j < 15; j++)
                    felder[i, j] = 0;
            }
        }

        /// <summary>
        /// Überladung des Indexoperators: Schreibt bzw. liest das Feld am Punkt P
        /// </summary>
        /// <param name="P"></param>
        /// <returns></returns>
        public int this[Point P]
        {
            get
            {
                return felder[P.X, P.Y];
            }
            set
            {
                felder[P.X, P.Y] = value;
            }
        }
    }
}
