﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Xml.Serialization;

namespace zeasedris
{
    public partial class zeasedris : Form
    {
        /// <summary>
        /// Hauptfenster für Spiel zeasedris
        /// Beinhaltet die ganzen Fenstersachen und eine Instanz von Spielfeld, die das wirkliche Spiel beinhaltet. 
        /// </summary>
        Spielfeld feld;
        Optionen opt;
        Score high;
        bool autofüll;
        public zeasedris()
        {
            InitializeComponent();
            high = FileOperations.Quickload();
            autofüll = false;
        }
        
        private void button1_Click(object sender, EventArgs e)
        {
            // Startet ein neues Spiel nur, falls keins läuft
            if (feld == null || !feld.spielläuft)
                feld = new Spielfeld(pictureBox1, pictureBox2, punktelabel2, levellabel2, autofüll, high);
        }


        private void zeasedris_KeyDown(object sender, KeyEventArgs e)
        {
            /* Sollte eigentlich mit dem auskommentierten Teil funktionieren, tut es aber nicht */
            /*if ((e.KeyData & Keys.Left) == Keys.Left)
                feld.steinbewegen(feld.aktiverstein, 9);
            else if ((e.KeyData & Keys.Right) == Keys.Right)
                feld.steinbewegen(feld.aktiverstein, 3);
            else if ((e.KeyData & Keys.Down) == Keys.Down)
                feld.steinbewegen(feld.aktiverstein, 6);*/
            if (feld != null && feld.aktiverstein != null)
            {
                if (e.KeyData == Keys.Left)
                    feld.steinbewegen(feld.aktiverstein, 9);
                else if (e.KeyData == Keys.Right)
                    feld.steinbewegen(feld.aktiverstein, 3);
                else if (e.KeyData == Keys.Down)
                    feld.steinbewegen(feld.aktiverstein, 6);
                else if (e.KeyData == Keys.Up)
                    feld.steinbewegen(feld.aktiverstein, 12);
            }
        }
        
        private void zeasedris_FormClosing(object sender, FormClosingEventArgs e)
        {
            // Den Thread beim Programmende beenden
            if (feld != null)
                if (feld.meinthread != null)
                    feld.meinthread.Abort();
        }

        private void button1_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            // Der Button blockiert sonst die Tastatureingaben
            Keys keyData = e.KeyData;
            if ((keyData & Keys.Left) == Keys.Left)
                e.IsInputKey = true;
            if ((keyData & Keys.Right) == Keys.Right)
                e.IsInputKey = true;
            if ((keyData & Keys.Up) == Keys.Up)
                e.IsInputKey = true;
            if ((keyData & Keys.Down) == Keys.Down)
                e.IsInputKey = true;
            if ((keyData & Keys.Space) == Keys.Space)
                e.IsInputKey = true;

        }

        private void neuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Spiel kann auch aus dem Menü gestartet werden
            if (feld != null)
                if (feld.meinthread != null)
                    feld.meinthread.Abort();
            feld = new Spielfeld(pictureBox1, pictureBox2, punktelabel2, levellabel2, autofüll, high);
        }


        private void beendenToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            // Beenden im Menü beendet nur das Spiel, nicht das Programm
            if (feld != null)
            {
                feld.spielläuft = false;
                if (feld.meinthread != null)
                    feld.meinthread.Abort();
            }
        }


        private void schließenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Schließen beendet das Programm
            if (feld != null)
                if (feld.meinthread != null)
                    feld.meinthread.Abort();
            this.Close();
        }

        private void optionenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Ruft den Optionendialog auf und setzt autofüll entsprechend
            if (opt == null)
                opt = new Optionen();
            if (opt.ShowDialog() == DialogResult.OK)
            {
                autofüll = opt.radioButton2.Checked;
            }
        }

        private void highscoreToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Highscore anzeigen
            Highscore highscore = new Highscore();
            for (int i=0;i<10;i++)
            {
                highscore.namensliste.Items.Add(high.namenslist[i]);
                highscore.namensliste.Items.Add("");
                highscore.punkteliste.Items.Add(high.punktelist[i].ToString());
                highscore.punkteliste.Items.Add("");
            }
            highscore.Show();
        }

    }

    public static class FileOperations
    {
        /// <summary>
        /// Klasse um Highscore serialisiert zu speichern
        /// Stellt Quickload und Quicksave zur Verfügung
        /// Falls die Higscoredatei (Highscore.zes) nicht existiert, lege einen neuen Highscore an. 
        /// Ansonsten laden.
        /// </summary>
        /// <param name="instanz"></param>
        public static void Quicksave(Score instanz)
        {
            FileStream fs = File.Create("Highscore.zes");
            try { new XmlSerializer(typeof(Score)).Serialize(fs, instanz); }
            catch { }
            finally { fs.Close();}
        }
        public static Score Quickload()
        {
            FileStream fs;
            Score instanz;
            try
            {
                XmlSerializer xml = new XmlSerializer(typeof(Score));
                fs = File.Open("Highscore.zes", FileMode.Open);
                instanz = null;
                try { instanz = (Score)xml.Deserialize(fs); }
                catch { instanz = new Score(true); }
                finally { fs.Close(); }
            }
            catch { instanz = new Score(true); }
            return instanz;
        }
    }

    [Serializable]
    public class Score
    {
        /// <summary>
        /// Klasse, die den Highscore beinhaltet. 
        /// Ist serialisierbar zum einfachen laden und speichern
        /// Enthält eine Namensliste und eine Punkteliste.
        /// </summary>
        public List<string> namenslist;
        public List<int> punktelist;
        public Score()
        {
            
        }

        public Score(bool neu)
        {
            namenslist = new List<string>();
            punktelist = new List<int>();
            for (int i = 0; i < 10; i++)
            {
                namenslist.Add("zeased");
                punktelist.Add(0);
            }
        }

        //public static void speicherhigh(


        public void neuerhighscore(int punkte)
        {
            // Prüfe und schreibe neuen Highscore. Falls neuer Highscore, frage nach Namen. Speicher auch sofort
            for (int i = 0; i < 10; i++)
            {
                if (punktelist[i] < punkte)
                {
                    punktelist.Insert(i, punkte);
                    punktelist.RemoveAt(10);

                    namensabfrage name = new namensabfrage();
                    name.platzlabel.Text = (i+1).ToString();
                    name.ShowDialog();
                    namenslist.Insert(i, name.textBox1.Text);
                    namenslist.RemoveAt(10);

                    break;
                }
            }
            FileOperations.Quicksave(this);
        }
    }

    public class Spielstein
    {
        /// <summary>
        /// Klasse Spielstein legt einige Dinge fest, die für jeden Spielstein gelten. 
        /// Alle unterschiedlichen Spielsteine erben davon.
        /// Pos ist ein 4x4 Array, in dem gespeichert ist, welche x und y Koordinaten vom Stein belegt sind.
        /// Absolute Steinposition steht in absolutx und y.
        /// </summary>
        public int wh = 25;
        public SolidBrush brush;
        public Rectangle rect = new Rectangle();
        public int[,] pos;
        public double hoch, seitlich;
        public int absolutx, absoluty;
        public Spielstein()
        {
            rect.X = 0;
            rect.Y = 0;
            rect.Height = wh;
            rect.Width = wh;
            absolutx = 4;
            absoluty = 0;
            pos = new int[4, 2];
        }

        public Spielstein Clone()
        {
            Spielstein neu = new Spielstein();
            for (int i = 0; i < 4; i++)
            {
                neu.pos[i,0] = this.pos[i,0];
                neu.pos[i, 1] = this.pos[i, 1];
            }
            neu.absolutx = this.absolutx;
            neu.absoluty = this.absoluty;
            return neu;
        }

        public void zeichnerect(Graphics g)
        {
            g.FillRectangle(brush, rect);
        }

        

        public void zeichnevorschaustein(PictureBox vorschaubox)
        {
            // Stein in der Vorschaubox zeichnen. Wird von manchen überschrieben, damit Ränder passen.
            Bitmap bmp = new Bitmap(vorschaubox.Height, vorschaubox.Width);
            Graphics g = Graphics.FromImage(bmp);
            for (int i = 0; i < 4; i++)
            {
                rect.X = (int)((pos[i, 0] + seitlich) * wh);
                rect.Y = (int)((pos[i, 1] + hoch) * wh);
                this.zeichnerect(g);
            }
            vorschaubox.Image = bmp;
            vorschaubox.Refresh();
        }

        public virtual void rotier()
        {
            int dummy;
            for (int i = 0; i < 4; i++)
            {
                dummy = -pos[i, 1];
                pos[i, 1] = pos[i, 0];
                pos[i, 0] = dummy;
            }
        }
    }

    public class Stab : Spielstein
    {
        /// <summary>
        /// Stab und co. erben von Spielstein und überschreiben teilweise Funktionen von Spielstein.
        /// Zudem wird jedesmal das pos Array gesetzt.
        /// </summary>
        public Stab()
        {
            brush = new SolidBrush(Color.Purple);
            pos[0,0] = -1;
            pos[0,1] = 0;
            pos[1,0] = 0;
            pos[1,1] = 0;
            pos[2,0] = 1;
            pos[2,1] = 0;
            pos[3,0] = 2;
            pos[3,1] = 0;
            //pos = {{-1,0},{0,0},{1,0},{2,0}};
            hoch=2;
            seitlich=1.5;
        }
    }

    public class Tee : Spielstein
    {
        public Tee()
        {
            brush = new SolidBrush(Color.Orange);
            pos[0, 0] = -1;
            pos[0, 1] = 0;
            pos[1, 0] = 0;
            pos[1, 1] = -1;
            pos[2, 0] = 0;
            pos[2, 1] = 0;
            pos[3, 0] = 1;
            pos[3, 1] = 0;
            hoch = 2.5;
            seitlich = 2;
        }
    }

    public class Zet : Spielstein
    {
        public Zet()
        {
            brush = new SolidBrush(Color.Turquoise);
            pos[0, 0] = -1;
            pos[0, 1] = -1;
            pos[1, 0] = 0;
            pos[1, 1] = -1;
            pos[2, 0] = 1;
            pos[2, 1] = 0;
            pos[3, 0] = 0;
            pos[3, 1] = 0;
            hoch=2.5;
            seitlich=2;
        }
    }

    public class Es : Spielstein
    {
        public Es()
        {
            brush = new SolidBrush(Color.Magenta);
            pos[0, 0] = 1;
            pos[0, 1] = -1;
            pos[1, 0] = -1;
            pos[1, 1] = 0;
            pos[2, 0] = 0;
            pos[2, 1] = -1;
            pos[3, 0] = 0;
            pos[3, 1] = 0;
            hoch=2.5;
            seitlich=2;
        }
    }

    public class Ell : Spielstein
    {
        public Ell()
        {
            brush = new SolidBrush(Color.Green);
            pos[0, 0] = 1;
            pos[0, 1] = -1;
            pos[1, 0] = 1;
            pos[1, 1] = 0;
            pos[2, 0] = 0;
            pos[2, 1] = 0;
            pos[3, 0] = -1;
            pos[3, 1] = 0;
            hoch=2.5;
            seitlich=2;
        }
    }

    public class Lle : Spielstein
    {
        public Lle()
        {
            brush = new SolidBrush(Color.Yellow);
            pos[0, 0] = -1;
            pos[0, 1] = -1;
            pos[1, 0] = -1;
            pos[1, 1] = 0;
            pos[2, 0] = 0;
            pos[2, 1] = 0;
            pos[3, 0] = 1;
            pos[3, 1] = 0;
            hoch=2.5;
            seitlich=2;
        }
    }

    public class Quadrat : Spielstein
    {
        public Quadrat()
        {
            brush = new SolidBrush(Color.Red);
            pos[0, 0] = 1;
            pos[0, 1] = -1;
            pos[1, 0] = 0;
            pos[1, 1] = -1;
            pos[2, 0] = 0;
            pos[2, 1] = 0;
            pos[3, 0] = 1;
            pos[3, 1] = 0;
            hoch=2.5;
            seitlich=1.5;
        }
        public override void rotier()
        {
            
        }
    }

    public class Spielfeld 
    {
        /// <summary>
        /// In der Klasse Spielfeld findet das eigentlich Spiel statt. 
        /// Das Feld ist ein Array, in dem die belegten Felder gespeichert werden. 
        /// Das komplette Feld wird nur neu gezeichnet, wenn ein Stein abgelegt wird. 
        /// </summary>
        public bool spielläuft;
        delegate void DelegateType();
        DelegateType meindelegate;
        public Thread meinthread;
        PictureBox feldbox, vorschaubox;
        Bitmap hintergrundbmp;
        Label punktelabel2, levellabel2;
        Random rand;
        public Spielstein aktiverstein, nächsterstein;
        public Score high;
        public int[,] feld;
        int wh=25, level, zeit;
        List<SolidBrush> brushlist;

        public Spielfeld(PictureBox fbox, PictureBox vbox, Label plabel, Label llabel, bool autofüll, Score spielfeldhigh)
        {
            meindelegate = new DelegateType(autofall);
            rand = new Random();
            feldbox = fbox;
            vorschaubox = vbox;
            punktelabel2 = plabel;
            high = spielfeldhigh;
            punktelabel2.Text = "0";
            levellabel2 = llabel;
            zeit = 1000;
            level = 1;
            levellabel2.Text = level.ToString();
            hintergrundbmp = new Bitmap(feldbox.Width, feldbox.Height);
            brushlist = new List<SolidBrush>();
            feld = new int[10, 18];
            for (int i = 0; i < 10; i++)
            {
                for (int j = 0; j < 18; j++)
                {
                    feld[i,j]=0;
                }
            }
            brushlist.Add(new SolidBrush(Color.Black));
            brushlist.Add(new SolidBrush(Color.Purple));
            brushlist.Add(new SolidBrush(Color.Orange));
            brushlist.Add(new SolidBrush(Color.Turquoise));
            brushlist.Add(new SolidBrush(Color.Magenta));
            brushlist.Add(new SolidBrush(Color.Green));
            brushlist.Add(new SolidBrush(Color.Yellow));
            brushlist.Add(new SolidBrush(Color.Red));
            if (autofüll)
            {
                füll();
                vollereihe();
            }
            zeichnefeld();
            aktiverstein = zufallsstein(rand);
            zeichnestein(aktiverstein);
            nächsterstein = zufallsstein(rand);
            nächsterstein.zeichnevorschaustein(vorschaubox);
            meinthread = new Thread(zeitthread);
            meinthread.Start((Object)zeit);
            spielläuft = true;
        }

        public void füll()
        {
            // Unteres Spielfeld zufällig füllen
            for (int i = 14; i < 18; i++)
            {
                for (int j = 0; j < 10; j++)
                {
                    int zufall = rand.Next(0, 3);
                    if (zufall == 0)
                        continue;
                    zufall = rand.Next(1, 8);
                    feld[j, i] = zufall;
                }
            }
        }

        public void vollereihe()
        {
            // Wurde eine Reihe vollständig gefüllt?
            // Dann lösche die Reihe und verteile Punkte
            // Falls neues Level, stoppe Autofallthread und starte mit kürzerer Zeitkonstante neu
            int zähler = 0;
            for (int i = 0; i < 18; i++)
            {
                bool reihevoll = true;
                for (int j = 0; j < 10; j++)
                {
                    if (feld[j, i] == 0)
                        reihevoll = false;
                }
                if (reihevoll)
                {
                    zähler += 1;
                    for (int k = i; k > 0; k--)
                    {
                        for (int j = 0; j < 10; j++)
                        {
                            feld[j, k] = feld[j, k-1];
                        }
                    }
                    for (int j=0;j<10;j++)
                    {
                        feld[j,0] = 0;
                    }
                    int punkte = int.Parse(punktelabel2.Text);
                    punkte = punkte + zähler;
                    punktelabel2.Text = punkte.ToString();
                    if (punkte >= 15 * level)
                    {
                        level++;
                        levellabel2.Text = level.ToString();
                        zeit = (int)(zeit * 0.8);
                        if (meinthread != null)
                            meinthread.Abort();
                        meinthread = new Thread(zeitthread);
                        meinthread.Start((Object)zeit);
                    }
                }
            }
            zähler = 0;
        }

        public void Steinauffeld(Spielstein stein)
        {
            // Stein wird teil vom Spielfeld
            int art;
            if (stein is Stab)
                art = 1;
            else if (stein is Tee)
                art = 2;
            else if (stein is Zet)
                art = 3;
            else if (stein is Es)
                art = 4;
            else if (stein is Ell)
                art = 5;
            else if (stein is Lle)
                art = 6;
            else if (stein is Quadrat)
                art = 7;
            else
                art = 0;
            
            if (!anstoßabfrage(nächsterstein))
            {
                spielläuft = false;
                if (meinthread != null)
                    meinthread.Abort();
                MessageBox.Show("Verloren! Bääätsch");
                high.neuerhighscore(int.Parse(punktelabel2.Text));
                return;
            }
            for (int i = 0; i < 4; i++)
            {
                if (stein.pos[i, 1] + stein.absoluty < 0)
                {
                    spielläuft = false;
                    if (meinthread != null)
                        meinthread.Abort();
                    MessageBox.Show("Verloren! Bääätsch");
                    high.neuerhighscore(int.Parse(punktelabel2.Text));
                    return;
                }
            }

            for (int i = 0; i < 4; i++)
                feld[stein.pos[i,0] + stein.absolutx, stein.pos[i,1] + stein.absoluty] = art;
            
            aktiverstein = nächsterstein;
            nächsterstein = zufallsstein(rand);
            nächsterstein.zeichnevorschaustein(vorschaubox);
            vollereihe();

            zeichnefeld();
            zeichnestein(aktiverstein);
        }

        public Spielstein zufallsstein(Random rand)
        {
            // Gib zufällig einen neuen Stein
            int art = rand.Next(1, 8);
            if (art == 1)
            {
                return new Stab();
            }
            if (art == 2)
            {
                return new Tee();
            }
            if (art == 3)
            {
                return new Zet();
            }
            if (art == 4)
            {
                return new Es();
            }
            if (art == 5)
            {
                return new Ell();
            }
            if (art == 6)
            {
                return new Lle();
            }
            if (art == 7)
            {
                return new Quadrat();
            }
            return new Stab();
        }

        public void zeichnefeld()
        {
            // Zeichne das Feld (Hintergrund)
            Graphics g = Graphics.FromImage(hintergrundbmp);
            for (int i=0;i<10;i++)
            {
                for (int j=0;j<18;j++)
                {
                    g.FillRectangle(brushlist[feld[i,j]],i*wh,j*wh,wh,wh);
                }
            }
            feldbox.Image = hintergrundbmp;
            feldbox.Refresh();
        }

        public void zeichnestein(Spielstein stein)
        {
            // Zeichne den aktiven Stein auf den Hintergrund
            Bitmap kopiebmp = (Bitmap)hintergrundbmp.Clone();
            Graphics g = Graphics.FromImage(kopiebmp);
            for (int i = 0; i < 4; i++)
            {
                int x  = (stein.pos[i,0] + stein.absolutx) * wh;
                int y = (stein.pos[i,1] + stein.absoluty) * wh;
                g.FillRectangle(stein.brush, x, y, wh, wh);
            }
            feldbox.Image = kopiebmp;
            feldbox.Refresh();
        }


        public void steinbewegen(Spielstein stein, int richtung)
        {
            // Bewege den Stein, mach lock, damit autofallthread und Spielereingabe sich nicht in die Quere kommen
            if (!spielläuft)
                return;
            lock(this)
            {
                Spielstein kopiestein = stein.Clone();
                steinimmerbewegen(kopiestein, richtung);
                if (anstoßabfrage(kopiestein) == true)
                {
                    steinimmerbewegen(stein, richtung);
                    zeichnestein(stein);
                }
                else if (anstoßabfrage(kopiestein) == false && richtung == 6)
                {
                    Steinauffeld(stein);
                }
            }
        }

        public void steinimmerbewegen(Spielstein stein, int richtung)
        {
            // Um schnelles runtefallen zu realisieren
            if (richtung == 6)
            {
                stein.absoluty += 1;
            }
            else if (richtung == 9)
            {
                stein.absolutx -= 1;
            }
            else if (richtung == 3)
            {
                stein.absolutx += 1;
            }
            else if (richtung == 12)
            {
                stein.rotier();
            }
        }

        public bool anstoßabfrage(Spielstein kopiestein)
        {
            // Stößt der Stein an?
            for(int i =0; i<4; i++)
            {
                int x = kopiestein.pos[i,0]+kopiestein.absolutx;
                int y = kopiestein.pos[i, 1] + kopiestein.absoluty;
                if (x > 9 || x<0)
                {
                    return false;
                }
                if (y > 17)
                {
                    return false;
                }
                if (y < 0)
                    continue;
                if(feld[x,y]!=0)
                {
                    return false;
                }
                
            }
            return true;
        }
        
        void autofall()
        {
            // Delegate zum automatischen Fallen.
            steinbewegen(aktiverstein, 6);
        }

        void zeitthread(Object obj)
        {
            // Thread für das automatische Fallen. Der zeitliche Abstand wird übergeben.
            int zeit = (int)obj;
            Thread.Sleep(zeit);
            while (true)
            {
                if(feldbox != null)
                    feldbox.Invoke(meindelegate);
                Thread.Sleep(zeit);
            }
        }
    }

}
